/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.JTextArea;

public class Feld {
    private Zelle[][] Spielfeld;
    private int sizex = 9;
    private int sizey = 9;
    private int[] GroupSize = new int[]{3, 3};
    private int[][] Gruppen;
    private JTextArea output = null;
    private int counter = 1;

    public Feld(JTextArea out) {
        this.Spielfeld = new Zelle[this.sizey][this.sizex];
        this.Gruppen = new int[this.sizey][this.sizex];
        this.determineGroupNumber();
        for (int i = 0; i < this.sizey; ++i) {
            for (int j = 0; j < this.sizex; ++j) {
                this.Spielfeld[i][j] = new Zelle(i + 1, j + 1, this.Gruppen[i][j]);
            }
        }
        this.output = out;
    }

    private void determineGroupNumber() {
        int rx = 0;
        int ry = 0;
        int groupx = 1;
        int groupy = 0;
        for (int i = 0; i < this.sizey; ++i) {
            if (ry == this.GroupSize[0]) {
                groupy += this.sizex / this.GroupSize[1];
                ry = 0;
            }
            ++ry;
            rx = 0;
            groupx = 1;
            for (int j = 0; j < this.sizex; ++j) {
                if (rx == this.GroupSize[1]) {
                    ++groupx;
                    rx = 0;
                }
                ++rx;
                this.Gruppen[i][j] = groupx + groupy;
            }
        }
    }

    public void setstartvalue(int x, int y, int value) {
        this.Spielfeld[y][x].setendvalue(value);
    }

    public void setstartvalue(Zelle[][] Values) {
        System.arraycopy(Values, 0, this.Spielfeld, 0, Values.length);
    }

    public boolean solved() {
        for (int i = 0; i < this.sizey; ++i) {
            for (int j = 0; j < this.sizex; ++j) {
                if (this.Spielfeld[i][j].getendvalue() != 0) continue;
                return false;
            }
        }
        return true;
    }

    private void removeduplicates() {
        for (int i = 0; i < this.sizey; ++i) {
            for (int j = 0; j < this.sizex; ++j) {
                int k;
                if (this.Spielfeld[i][j].left() != 1) continue;
                int lastvalue = this.Spielfeld[i][j].getendvalue();
                for (k = 0; k < this.sizex; ++k) {
                    this.Spielfeld[i][k].eliminateZahl(lastvalue);
                }
                for (k = 0; k < this.sizey; ++k) {
                    this.Spielfeld[k][j].eliminateZahl(lastvalue);
                }
                for (k = 0; k < this.sizey; ++k) {
                    for (int l = 0; l < this.sizex; ++l) {
                        if (this.Spielfeld[k][l].getGroup() != this.Spielfeld[i][j].getGroup()) continue;
                        this.Spielfeld[k][l].eliminateZahl(lastvalue);
                    }
                }
            }
        }
    }

    private void uniquechance() {
        for (int i = 0; i < this.sizey; ++i) {
            for (int j = 0; j < this.sizex; ++j) {
                for (int a : this.Spielfeld[i][j].getRemainvalues()) {
                    if (a == 0) continue;
                    int countdoubleinline = 0;
                    for (int k = 0; k < this.sizex; ++k) {
                        if (!this.Spielfeld[i][k].find(a)) continue;
                        ++countdoubleinline;
                    }
                    int countdoubleinrow = 0;
                    for (int k = 0; k < this.sizey; ++k) {
                        if (!this.Spielfeld[k][j].find(a)) continue;
                        ++countdoubleinrow;
                    }
                    int countdoubleingroup = 0;
                    for (int k = 0; k < this.sizey; ++k) {
                        for (int l = 0; l < this.sizex; ++l) {
                            if (this.Spielfeld[k][l].getGroup() != this.Spielfeld[i][j].getGroup() || !this.Spielfeld[k][l].find(a)) continue;
                            ++countdoubleingroup;
                        }
                    }
                    if (countdoubleinline != 1 && countdoubleinrow != 1 && countdoubleingroup != true) continue;
                    this.Spielfeld[i][j].setendvalue(a);
                }
            }
        }
    }

    private void onevalue() {
        for (int i = 0; i < this.sizey; ++i) {
            block1: for (int j = 0; j < this.sizex; ++j) {
                if (this.Spielfeld[i][j].left() != 1) continue;
                for (int Zahl : this.Spielfeld[i][j].getRemainvalues()) {
                    if (Zahl == 0) continue;
                    this.output.append(this.counter++ + ": " + "X:" + (9 - i) + " Y:" + (9 - j) + " Value:" + Zahl + "\n");
                    this.Spielfeld[i][j].setendvalue(Zahl);
                    continue block1;
                }
            }
        }
    }

    private void extrules() {
        int Gruppe = 1;
        int amount = 0;
        for (int i = 0; i < this.sizey; ++i) {
            for (int j = 0; j < this.sizex; ++j) {
                if (this.Spielfeld[i][j].getGroup() != Gruppe) continue;
                for (int k = 1; k <= 9; ++k) {
                    for (int y = 0; y <= 2; ++y) {
                        for (int x = 0; x <= 2; ++x) {
                            if (!this.Spielfeld[i + y][j + x].find(k)) continue;
                            ++amount;
                        }
                    }
                    if (amount == 2 || amount == 3) {
                        int l;
                        int z;
                        int[] countinline = new int[this.GroupSize[1]];
                        for (int z2 = 0; z2 <= 2; ++z2) {
                            for (int l2 = 0; l2 <= 2; ++l2) {
                                if (!this.Spielfeld[i + z2][j + l2].find(k)) continue;
                                int n = z2;
                                countinline[n] = countinline[n] + 1;
                            }
                        }
                        int[] countinrow = new int[this.GroupSize[0]];
                        for (z = 0; z <= 2; ++z) {
                            for (l = 0; l <= 2; ++l) {
                                if (!this.Spielfeld[i + l][j + z].find(k)) continue;
                                int n = z;
                                countinrow[n] = countinrow[n] + 1;
                            }
                        }
                        for (z = 0; z < this.GroupSize[1]; ++z) {
                            if (countinline[z] != amount) continue;
                            for (l = 0; l < this.sizex; ++l) {
                                if (this.Spielfeld[i + z][l].getGroup() == this.Spielfeld[i][j].getGroup()) continue;
                                this.Spielfeld[i + z][l].eliminateZahl(k);
                            }
                        }
                        for (z = 0; z < this.GroupSize[0]; ++z) {
                            if (countinrow[z] != amount) continue;
                            for (l = 0; l < this.sizex; ++l) {
                                if (this.Spielfeld[l][j + z].getGroup() == this.Spielfeld[i][j].getGroup()) continue;
                                this.Spielfeld[l][j + z].eliminateZahl(k);
                            }
                        }
                    }
                    amount = 0;
                }
                ++Gruppe;
            }
        }
    }

    public void solve() {
        for (int k = 0; !this.solved() && k <= 100; ++k) {
            this.removeduplicates();
            this.uniquechance();
            this.extrules();
            this.onevalue();
        }
    }

    public void printSpielfeld() {
        for (int i = this.sizey - 1; i >= 0; --i) {
            System.out.print("|");
            for (int j = this.sizex - 1; j >= 0; --j) {
                System.out.print(this.Spielfeld[i][Math.abs(j - 8)].getendvalue() + "|");
            }
            System.out.print("\n");
        }
    }

    public int[][] getcurSpielfeld() {
        int[][] curSpielfeld = new int[9][9];
        for (int i = 0; i < this.sizey; ++i) {
            for (int j = 0; j < this.sizex; ++j) {
                curSpielfeld[i][j] = this.Spielfeld[i][j].getendvalue();
            }
        }
        return curSpielfeld;
    }
}

