/*
 * Decompiled with CFR 0.152.
 */
package clcolortable;

import clcolortable.clGradientPanel;
import clcolortable.clMultiSlider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UserInterface
extends JFrame
implements ChangeListener,
ActionListener {
    private JLabel jlLength = new JLabel("Length:");
    private JSpinner jsLength = null;
    private SpinnerNumberModel model = new SpinnerNumberModel(256, 1, Integer.MAX_VALUE, 1);
    private JButton jbExit = new JButton("Exit");
    private JButton jbLoad = new JButton("Load");
    private JButton jbSave = new JButton("Save");
    private clGradientPanel colortable = new clGradientPanel(256);
    private clMultiSlider slider = new clMultiSlider(256);
    private JColorChooser jcc = new JColorChooser();
    private TreeMap<Integer, Color> colMapping = new TreeMap();
    private TreeMap<Integer, Integer> iMapping = null;

    public UserInterface() {
        this.setTitle("clColorTable");
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.jsLength = new JSpinner(this.model);
        this.setDefaultCloseOperation(3);
        this.setPreferredSize(new Dimension(700, 450));
        this.jsLength.setPreferredSize(new Dimension(100, 25));
        this.place(this.jlLength, gbl, 0, 0, 1, 1);
        this.place(this.jsLength, gbl, 1, 0, 1, 1);
        this.place(this.colortable, gbl, 0, 1, 1, 8);
        this.place(this.slider, gbl, 1, 1, 1, 8);
        this.place(this.jbSave, gbl, 0, 9, 1, 1);
        this.place(this.jcc, gbl, 2, 0, 4, 9);
        this.pack();
        this.setVisible(true);
        this.jbSave.addActionListener(this);
        this.jbSave.setActionCommand("Save");
        this.jsLength.addChangeListener(new cla());
        this.jcc.getSelectionModel().addChangeListener(this);
        this.slider.addActionListener(this);
        this.slider.setActionCommand("Change");
    }

    private void place(JComponent comp, GridBagLayout gblayout, int x, int y, int wx, int wy) {
        GridBagConstraints c = new GridBagConstraints(x, y, wx, wy, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        gblayout.setConstraints(comp, c);
        this.add(comp);
    }

    private void writeColorTable(String filename) {
        try {
            FileWriter fw = new FileWriter(filename + ".csv");
            int[] ct = this.colortable.getColorTable();
            int red = 0;
            int green = 0;
            int blue = 0;
            fw.write("Index\tRed\tGreen\tBlue\n");
            for (int i = 0; i < ct.length; ++i) {
                red = ct[i] << 8 >>> 24;
                green = ct[i] << 16 >>> 24;
                blue = ct[i] << 24 >>> 24;
                fw.write(i + "\t" + red + "\t" + green + "\t" + blue + "\n");
            }
            fw.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(UserInterface.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(UserInterface.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        new UserInterface();
    }

    public void stateChanged(ChangeEvent e) {
        if (this.slider.getCurrentSelection() == null) {
            return;
        }
        this.colMapping.put(this.slider.getCurrentSelection()[0], this.jcc.getColor());
        this.colortable.setDivisions(this.iMapping, this.colMapping);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Change")) {
            this.iMapping = this.slider.getSliders();
            for (Integer i : this.colMapping.keySet()) {
                if (this.iMapping.containsKey(i)) continue;
                this.colMapping.remove(i);
            }
            this.colortable.setDivisions(this.iMapping, this.colMapping);
        } else if (e.getActionCommand().equals("Save")) {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showSaveDialog(this);
            if (returnVal == 0) {
                this.writeColorTable(fc.getSelectedFile().toString());
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class cla
    implements ChangeListener {
        private cla() {
        }

        public void stateChanged(ChangeEvent e) {
            UserInterface.this.colortable.setGranularity(UserInterface.this.model.getNumber().intValue());
            UserInterface.this.slider.setGranularity(UserInterface.this.model.getNumber().intValue());
        }
    }
}

