/*
 * Decompiled with CFR 0.152.
 */
package clcolortable;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class clGradientPanel
extends JPanel {
    private int gran = 0;
    private BufferedImage gradientImage = null;
    private TreeMap<Integer, Color> divisions = null;

    public clGradientPanel(int granularity) {
        this.gran = granularity;
        this.gradientImage = new BufferedImage(1, this.gran, 1);
    }

    public void setDivisions(TreeMap<Integer, Integer> iDiv, TreeMap<Integer, Color> colDiv) {
        this.divisions = new TreeMap();
        Iterator<Integer> iter = colDiv.keySet().iterator();
        Integer index = null;
        while (iter.hasNext()) {
            index = iter.next();
            this.divisions.put(iDiv.get(index), colDiv.get(index));
        }
        this.paintGradient();
        this.repaint();
    }

    public void setGranularity(int granularity) {
        this.gran = granularity;
        this.paintGradient();
        this.repaint();
    }

    public int[] getColorTable() {
        int[] table = new int[this.gran];
        DataBuffer db = this.paintGradient().getRaster().getDataBuffer();
        for (int j = 0; j < db.getSize(); ++j) {
            table[j] = db.getElem(0, j);
        }
        return table;
    }

    private BufferedImage paintGradient() {
        this.gradientImage = new BufferedImage(1, this.gran, 1);
        Graphics2D g2d = this.gradientImage.createGraphics();
        Iterator<Integer> iter = this.divisions.keySet().iterator();
        Integer value = 0;
        Color colValue = Color.black;
        Color tmpValue = Color.black;
        int index = 0;
        while (iter.hasNext()) {
            value = iter.next();
            colValue = this.divisions.get(value);
            if (index == 0 && value > 0) {
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, Color.black, 0.0f, value.intValue(), colValue));
                g2d.fillRect(0, 0, 10, value);
                tmpValue = colValue;
                index = value;
                continue;
            }
            if (index == 0 && value == 0) {
                tmpValue = colValue;
                if (!iter.hasNext()) break;
                value = iter.next();
                colValue = this.divisions.get(value);
            }
            g2d.setPaint(new GradientPaint(0.0f, index, tmpValue, 0.0f, value.intValue(), colValue));
            g2d.fillRect(0, index, 10, value);
            tmpValue = colValue;
            index = value;
        }
        if (index < this.gran) {
            g2d.setPaint(new GradientPaint(0.0f, index, tmpValue, 0.0f, this.gran - 1, Color.black));
            g2d.fillRect(0, index, 10, this.gran - 1);
        }
        return this.gradientImage;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.gradientImage.getWidth() != this.getWidth()) {
            AffineTransformOp scaleOP = new AffineTransformOp(AffineTransform.getScaleInstance((double)this.getWidth() / (double)this.gradientImage.getWidth(), (double)(this.getHeight() - 20) / (double)this.gradientImage.getHeight()), 1);
            this.gradientImage = scaleOP.filter(this.gradientImage, null);
        }
        g.drawImage(this.gradientImage, 0, 10, this);
    }
}

