/*
 * Decompiled with CFR 0.152.
 */
package clcolortable;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class clMultiSlider
extends JPanel {
    private static final int YSHIFT = 10;
    private static final int XSHIFT = 20;
    private static final int SLIDERYSHIFT = 3;
    private static final int SLIDERXSHIFT = 6;
    private static final int SLIDERSELXSHIFT = 12;
    private static final int DISTLINESLIDER = 4;
    private int gran = 0;
    private int counter = 0;
    private TreeMap<Integer, Polygon> slider = new TreeMap();
    private Integer selIndex = null;
    private String cmd = "";

    public clMultiSlider(int granularity) {
        this.gran = granularity;
        MoLi ml = new MoLi();
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    private Map.Entry<Integer, Polygon> getSlider(int ypos) {
        Polygon tmp = null;
        Integer index2 = null;
        for (Integer index2 : this.slider.keySet()) {
            tmp = this.slider.get(index2);
            if (tmp.ypoints[1] > ypos || tmp.ypoints[2] < ypos) continue;
            return this.slider.ceilingEntry(index2);
        }
        return null;
    }

    private void addSlider(int ypos) {
        int sx = 24;
        int sy = ypos;
        int[] px = new int[]{sx, sx + 6, sx + 6};
        int[] py = new int[]{sy, sy - 3, sy + 3};
        this.slider.put(this.counter++, new Polygon(px, py, 3));
    }

    public int[] getCurrentSelection() {
        if (this.selIndex == null) {
            return null;
        }
        int value = (int)Math.round((double)((this.slider.get((Object)this.selIndex).ypoints[0] - 10) * (this.gran - 1)) / (double)(this.getHeight() - 20));
        return new int[]{this.selIndex, value};
    }

    public TreeMap<Integer, Integer> getSliders() {
        Integer index = null;
        Iterator<Integer> iter = this.slider.keySet().iterator();
        TreeMap<Integer, Integer> connect = new TreeMap<Integer, Integer>();
        while (iter.hasNext()) {
            index = iter.next();
            int value = (int)Math.round((double)((this.slider.get((Object)index).ypoints[0] - 10) * (this.gran - 1)) / (double)(this.getHeight() - 20));
            connect.put(index, value);
        }
        return connect;
    }

    public void setGranularity(int granularity) {
        this.gran = granularity;
        this.fireActionPerformed();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.darkGray);
        g.fillRect(20, 10, 2, this.getHeight() - 20);
        if (this.slider.size() == 0) {
            int sx = 24;
            int sy = 10;
            int[] px = new int[]{sx, sx + 6, sx + 6};
            int[] py = new int[]{sy, sy - 3, sy + 3};
            this.slider.put(this.counter++, new Polygon(px, py, 3));
            sy = this.getHeight() - 10;
            py = new int[]{sy, sy - 3, sy + 3};
            this.slider.put(this.counter++, new Polygon(px, py, 3));
        }
        Iterator<Integer> iter = this.slider.keySet().iterator();
        while (iter.hasNext()) {
            g.drawPolygon(this.slider.get(iter.next()));
        }
    }

    public void setActionCommand(String actionCommand) {
        this.cmd = actionCommand;
    }

    public String getActionCommand() {
        return this.cmd;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                String actionCommand = this.getActionCommand();
                e = new ActionEvent(this, 1001, actionCommand, System.currentTimeMillis(), 1);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    private class MoLi
    extends MouseAdapter {
        private Polygon curSel = null;
        private Polygon curSel2 = null;
        private int topBorder = 4;
        private int bottomBorder = clMultiSlider.this.getHeight() - 4;

        private MoLi() {
        }

        public void mouseClicked(MouseEvent e) {
            Map.Entry entry;
            if (e.getButton() == 1 && clMultiSlider.this.getSlider(e.getY()) == null) {
                clMultiSlider.this.addSlider(e.getY());
                this.setSelection(e);
            } else if (e.getButton() == 1 && clMultiSlider.this.getSlider(e.getY()) != null) {
                this.setSelection(e);
            } else if (e.getButton() == 3 && (entry = clMultiSlider.this.getSlider(e.getY())) != null) {
                if (((Polygon)clMultiSlider.this.slider.get(entry.getKey())).equals(this.curSel2)) {
                    this.curSel2 = null;
                }
                clMultiSlider.this.slider.remove(entry.getKey());
            }
            clMultiSlider.this.fireActionPerformed();
            clMultiSlider.this.repaint();
        }

        private void setSelection(MouseEvent e) {
            if (this.curSel2 != null) {
                int sx = 24;
                this.curSel2.xpoints = new int[]{sx, sx + 6, sx + 6};
            }
            Map.Entry entry = clMultiSlider.this.getSlider(e.getY());
            clMultiSlider.this.selIndex = (Integer)entry.getKey();
            this.curSel2 = (Polygon)entry.getValue();
            int sx = 24;
            this.curSel2.xpoints = new int[]{sx, sx + 12, sx + 12};
        }

        public void mouseDragged(MouseEvent e) {
            if (e.getButton() == 1 && this.curSel != null && e.getY() >= this.topBorder + 6 && e.getY() <= this.bottomBorder - 6) {
                this.curSel.translate(0, e.getY() - this.curSel.ypoints[0]);
                clMultiSlider.this.repaint();
                clMultiSlider.this.fireActionPerformed();
            }
        }

        public void mousePressed(MouseEvent e) {
            Map.Entry entry = clMultiSlider.this.getSlider(e.getY());
            if (entry != null) {
                this.curSel = (Polygon)clMultiSlider.this.getSlider(e.getY()).getValue();
                int y = this.curSel.ypoints[0];
                for (int i = 0; i < clMultiSlider.this.counter; ++i) {
                    Polygon tmp = (Polygon)clMultiSlider.this.slider.get(i);
                    if (tmp == null || tmp.equals(this.curSel)) continue;
                    int dy = ((Polygon)((clMultiSlider)clMultiSlider.this).slider.get((Object)Integer.valueOf((int)i))).ypoints[0] - y;
                    if (dy < 0 && ((Polygon)((clMultiSlider)clMultiSlider.this).slider.get((Object)Integer.valueOf((int)i))).ypoints[0] >= this.topBorder) {
                        this.topBorder = ((Polygon)((clMultiSlider)clMultiSlider.this).slider.get((Object)Integer.valueOf((int)i))).ypoints[0];
                    }
                    if (dy <= 0 || ((Polygon)((clMultiSlider)clMultiSlider.this).slider.get((Object)Integer.valueOf((int)i))).ypoints[0] > this.bottomBorder) continue;
                    this.bottomBorder = ((Polygon)((clMultiSlider)clMultiSlider.this).slider.get((Object)Integer.valueOf((int)i))).ypoints[0];
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.curSel = null;
            this.topBorder = 4;
            this.bottomBorder = clMultiSlider.this.getHeight() - 4;
        }
    }
}

